% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{idx_name}
\alias{idx_name}
\alias{idx_name.dfidx}
\alias{idx_name.idx}
\alias{idx_name.xseries}
\title{Get the name and the position of the index column}
\usage{
idx_name(x, n = 1, m = NULL)

\method{idx_name}{dfidx}(x, n = NULL, m = NULL)

\method{idx_name}{idx}(x, n = NULL, m = NULL)

\method{idx_name}{xseries}(x, n = NULL, m = NULL)
}
\arguments{
\item{x}{a \code{dfidx}, a \code{idx} or a \code{xseries} object}

\item{n}{the index to be extracted (1 or 2, ignoring the nesting
variables)}

\item{m}{if > 1, a nesting variable}
}
\value{
if \code{n} is \code{NULL}, a named integer which gives the position
and the name of the \code{idx} column in the \code{dfidx} object,
otherwise, a character of length 1
}
\description{
This function extract the names of the indexes (along with the
position of the \code{idx} column) or the name of a specific index
}
\examples{
mn <- dfidx(munnell, idx = c(region = "state", president = "year"))
# get the position of the idx column
idx_name(mn)
# get the name of the first index
idx_name(mn, 1)
# get the name of the second index
idx_name(mn, 2)
# get the name of the nesting variable for the second index
idx_name(mn, 2, 2)
}
\author{
Yves Croissant
}
