% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_learn_rate.R
\name{learn_rate}
\alias{learn_rate}
\title{Learning rate}
\usage{
learn_rate(range = c(-10, -1), trans = transform_log10())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
The parameter is used in boosting methods (\code{parsnip::boost_tree()}) or some
types of neural network optimization methods.
}
\details{
The parameter is used on the log10 scale. The units for the \code{range} function
are on this scale.

\code{learn_rate()} corresponds to \code{eta} in \pkg{xgboost}.
}
\examples{
learn_rate()
}
