% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/privacy_params.R
\docType{class}
\name{DPParamsDel-class}
\alias{DPParamsDel-class}
\alias{DPParamsDel}
\alias{show,DPParamsDel-method}
\alias{getDelta,DPParamsDel-method}
\alias{setDelta<-,DPParamsDel-method}
\alias{toGamma,DPParamsDel,numeric-method}
\title{An S4 class for relaxed differential privacy parameters.}
\usage{
\S4method{show}{DPParamsDel}(object)

\S4method{getDelta}{DPParamsDel}(object)

\S4method{setDelta}{DPParamsDel}(object) <- value

\S4method{toGamma}{DPParamsDel,numeric}(object, gamma)
}
\arguments{
\item{object}{an object of class \code{\link{DPParamsDel}}.}

\item{value}{a scalar numeric \eqn{\delta}.}

\item{gamma}{a scalar numeric \eqn{\gamma}.}
}
\description{
An S4 base class representing the privacy parameters in
\eqn{(\epsilon,\delta)}-differential privacy.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: automatically prints the object.

\item \code{getDelta}: getter for slot \code{delta}.

\item \code{setDelta<-}: setter for slot \code{delta}.

\item \code{toGamma}: returns object to corresponding instance of subclass
\code{\link{DPParamsGam}}.
}}

\section{Slots}{

\describe{
\item{\code{epsilon}}{positive scalar numeric privacy level.}

\item{\code{delta}}{a scalar numeric privacy level in interval [0,1).}
}}

\seealso{
\code{\link{DPParamsEps}} superclass,
\code{\link{DPParamsGam}} subclass for random relaxation.
}
