% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscSurvEstimation.R
\name{compRisksGEE}
\alias{compRisksGEE}
\alias{predict.dCRGEE}
\title{GEE model for discrete competing risks}
\usage{
compRisksGEE(
  datShort,
  dataTransform = "dataLongCompRisks",
  corstr = "independence",
  formulaVariable = ~timeInt,
  ...
)

\method{predict}{dCRGEE}(object, newdata, ...)
}
\arguments{
\item{datShort}{Original data set in short format with each row corresponding to one independent 
observation("class data.frame").}

\item{dataTransform}{Specification of the data transformation function from short to long format("character vector"). 
There are two available options: Without time dependent covariates ("dataLongCompRisks") and with 
time dependent covariates ("dataLongCompRisksTimeDep"). The default is set to the former.}

\item{corstr}{Assumption of correlation structure ("character vector"). The following are 
permitted: '"independence"', '"exchangeable"', '"ar1"', '"unstructured"' and '"userdefined".}

\item{formulaVariable}{Specifies the right hand side of the regression formula ("class formula").
The default is to use the discrete time variable, which corresponds to a covariate free hazard. 
It is recommended to always include the discrete time variable "timeInt".}

\item{\dots}{Additional arguments to data transformation (compRisksGEE) or prediction function (predict).
Preprocessing function argument responseAsFactor has to be set to FALSE (Default).}

\item{object}{Discrete time competing risks GEE model prediction model ("class dCRGEE").}

\item{newdata}{("class data.set") New data set to be used for prediction (class data.frame).}
}
\value{
Returns an object of class "geeglm".
}
\description{
Estimates generalized estimation equation model for each competing event separately. 
Dependence within person IDs is accounted for by assuming a working covariance structure.
}
\details{
Variables in argument \emph{formulaVariable} need to be separated by "+ ". 
For example if the two variables \emph{timeInt} and \emph{X1} should be included the formula would be
"~ timeInt + X1". The variable \emph{timeInt} is constructed before estimation of the model.
}
\examples{

# Example with unemployment data
library(Ecdat)
data(UnempDur)

# Select subsample
SubUnempDur <- UnempDur [1:100, ]

# Estimate GEE models for all events
estGEE <- compRisksGEE(datShort = SubUnempDur, dataTransform = "dataLongCompRisks", 
corstr = "independence", formulaVariable =~ timeInt + age + ui + logwage * ui, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell")
names(estGEE)
estGEE[[1]]

# Predictions
SubUnempDurLong <- dataLongCompRisks(dataShort = SubUnempDur, 
eventColumns = c("censor1", "censor2", "censor3", "censor4"), timeColumn = "spell")
preds <- predict(estGEE, newdata = SubUnempDurLong)
head(preds)

}
\references{
\insertRef{minjungDiscComp}{discSurv}
}
\seealso{
\code{\link{covarGEE}}, \code{\link{dataLongCompRisks}}, \code{\link{dataLongCompRisksTimeDep}}, 
\code{\link[geepack]{geeglm}}
}
\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}
\keyword{survival}
