% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTransitionTime.R
\name{getTransitionTime}
\alias{getTransitionTime}
\title{Transition Time}
\usage{
getTransitionTime(index.hsam, index.lsam, years, for.year = NULL)
}
\arguments{
\item{index.hsam}{A scalar/vector of index of HSAM values in given year/years}

\item{index.lsam}{A scalar/vector of index of LSAM values in given year/years}

\item{years}{A vector of years corresponding to HSAM and LSAM values.
This argument can be NULL if the HSAM and LSAM values are scalars.}

\item{for.year}{(optional) Calculate transition time only for the given year in this argument.
If argument is omitted, transition times for all years are calculated.}
}
\value{
Scalar transition time if the inputs are scalars, or a Data frame containing two Columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{transition.time} \tab Second column, represents transition times
}
}
\description{
Compute the number of days separating HSAM and LSAM for the given year/years.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# get HSAM and LSAM values
hsam = getHSAM(x.bl$resid.sig, x.streamflow$data$year)
lsam = getLSAM(x.bl$resid.sig, x.streamflow$data$year)

# transition time
tt = getTransitionTime(hsam$Index.all, lsam$Index.all, hsam$year)

}
