% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{exercise}
\alias{exercise}
\title{Exercise and emotional well-being data}
\format{
A tibble with 564 rows and 5 variables.
}
\source{
\href{https://www.discovr.rocks/csv/exercise.csv}{www.discovr.rocks/csv/exercise.csv}
}
\usage{
exercise
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
A psychologist was interested in the effects of exercise on emotional well-being. The researcher tracked emotional well-being over 12 months using the The Warwick-Edinburgh Mental Well-being Scale (WEMWBS). Half of the sample were randomised to an exercise programme involving 3 exercise classes per week.
The remaining participants were on a wait list to receive the same programme.
The data contains measures from 141 participants measured at four timepoints (baseline and 1, 6, and 12 month follow-up).
\itemize{
\item \strong{id}: The participant's id
\item \strong{intervention}: a factor that codes to which arm of the trial the participant was randomized (wait list or exercise).
\item \strong{time}: a categorical variable indicating at which phase of the trial emotional well-being was measured (Baseline, 1 month, 6 months or 12 months).
\item \strong{time_num}: a numerical variable indicating how many months since the intervention emotional well-being was measured.
\item \strong{wemwbs}: The participant's score on the The Warwick-Edinburgh Mental Well-being Scale (WEMWBS). Scores can range from 14 to 70 and a higher value equates to better emotional well-being.
}
}
\keyword{datasets}
