% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_boxplot_common.R
\name{utils_boxplot_common}
\alias{utils_boxplot_common}
\title{Common Boxplot Component of \code{distantia_boxplot()} and \code{momentum_boxplot()}}
\usage{
utils_boxplot_common(
  variable = NULL,
  value = NULL,
  fill_color = NULL,
  f = median,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  text_cex = 1
)
}
\arguments{
\item{variable}{(required, character vector) vector with variable or time series names. Default: NULL}

\item{value}{(required, numeric vector) vector of numeric values to compute the boxplot for. Must have the same length as \code{variable}. Default: NULL}

\item{fill_color}{(optional, character vector) boxplot fill color. Default: NULL}

\item{f}{(optional, function) function used to aggregate the input data frame and arrange the boxes. One of \code{mean} or \code{median}. Default: \code{median}.}

\item{main}{(optional, string) boxplot title. Default: NULL}

\item{xlab}{(optional, string) x axis label. Default: NULL}

\item{ylab}{(optional, string) y axis label. Default: NULL}

\item{text_cex}{(optional, numeric) Multiplier of the text size. Default: 1}
}
\value{
boxplot
}
\description{
Common Boxplot Component of \code{distantia_boxplot()} and \code{momentum_boxplot()}
}
\examples{
utils_boxplot_common(
  variable = rep(x = c("a", "b"), times = 50),
  value = stats::runif(100)
)
}
\seealso{
Other internal: 
\code{\link{utils_check_args_distantia}()},
\code{\link{utils_check_args_matrix}()},
\code{\link{utils_check_args_momentum}()},
\code{\link{utils_check_args_path}()},
\code{\link{utils_check_args_tsl}()},
\code{\link{utils_check_args_zoo}()},
\code{\link{utils_check_distance_args}()},
\code{\link{utils_check_list_class}()},
\code{\link{utils_clean_names}()},
\code{\link{utils_digits}()},
\code{\link{utils_distantia_df_split}()},
\code{\link{utils_prepare_df}()},
\code{\link{utils_prepare_matrix}()},
\code{\link{utils_prepare_matrix_list}()},
\code{\link{utils_prepare_time}()},
\code{\link{utils_prepare_vector_list}()},
\code{\link{utils_prepare_zoo_list}()},
\code{\link{utils_tsl_pairs}()}
}
\concept{internal}
