% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_plot.R
\name{zoo_plot}
\alias{zoo_plot}
\title{Plot Zoo Time Series}
\usage{
zoo_plot(
  x = NULL,
  line_color = NULL,
  line_width = 1,
  xlim = NULL,
  ylim = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  text_cex = 1,
  guide = TRUE,
  guide_position = "topright",
  guide_cex = 0.8,
  vertical = FALSE,
  subpanel = FALSE
)
}
\arguments{
\item{x}{(required, zoo object) zoo time series. Default: NULL}

\item{line_color}{(optional, character vector) vector of colors for the distance or cost matrix. If NULL, uses an appropriate palette generated with \code{\link[grDevices:palette]{grDevices::palette.colors()}}. Default: NULL}

\item{line_width}{(optional, numeric vector) Width of the time series lines. Default: 1}

\item{xlim}{(optional, numeric vector) Numeric vector with the limits of the x axis. Default: NULL}

\item{ylim}{(optional, numeric vector) Numeric vector with the limits of the x axis. Default: NULL}

\item{title}{(optional, character string) Main title of the plot. If NULL, it's set to the name of the time series. Default: NULL}

\item{xlab}{(optional, character string) Title of the x axis. Disabled if \code{subpanel} or \code{vertical} are TRUE. If NULL, the word "Time" is used. Default: NULL}

\item{ylab}{(optional, character string) Title of the x axis. Disabled if \code{subpanel} or \code{vertical} are TRUE. If NULL, it is left empty. Default: NULL}

\item{text_cex}{(optional, numeric) Multiplicator of the text size. Default: 1}

\item{guide}{(optional, logical) If TRUE, plots a legend. Default: TRUE}

\item{guide_position}{(optional, vector of xy coordinates or character string). This is a condensed version of the \code{x} and \code{y} arguments of the \code{\link[graphics:legend]{graphics::legend()}} function. Coordinates (in the range 0 1) or keyword to position the legend. Accepted keywords are: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and "center". Default: "topright".}

\item{guide_cex}{(optional, numeric) Size of the guide's text and separation between the guide's rows. Default: 0.7.}

\item{vertical}{(optional, logical) For internal use within the package in multipanel plots. Switches the plot axes. Disabled if \code{subpanel = FALSE}. Default: FALSE}

\item{subpanel}{(optional, logical) For internal use within the package in multipanel plots. Strips down the plot for a sub-panel. Default: FALSE}
}
\value{
A plot.
}
\description{
Plot Zoo Time Series
}
\examples{

#simulate zoo time series
x <- zoo_simulate()

if(interactive()){

  zoo_plot(
    x = x,
    xlab = "Date",
    ylab = "Value",
    title = "My time series"
  )

}
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
\keyword{plotting}
