get_cov.lmerMod <- function(m, verbose){
  if(isTRUE(verbose)) message("Extracting covariance structure from lmerMod object...")
  re <- crossprod(as.matrix(getME(m,"Lambdat")))
  Z <- as.matrix(getME(m, "Z"))
  sig <- sigma(m)^2
  Sigma <- sig*(Z %*% re %*% t(Z)) + diag(sig/weights(m, type = "prior"), nrow(Z))
  return(list(Sigma = Sigma))
}


