f2ftheta <- function(f, X, n){
  stopifnot(is.function(f))
  if("x" %in% names(formals(f))){
    stopifnot(is.matrix(X))
    validate_numeric(x = X)
    output <- function(theta) apply(X, MARGIN = 1, FUN = f, theta = theta)
  } else {
    if("X" %in% names(formals(f))){
      output <- function(theta) f(X = X, theta = theta)
    } else {
      stopifnot(is.numeric(n), n > 0)
      output <- function(theta) rep(unname(theta), n)
    }
  }
  return(output)
}