validate_covariance_list <- function(covariance_list, n, sym_tol, sym_tol1){
  list_name <- deparse1(substitute(covariance_list))
  validate_named_list(covariance_list, valid_names = c("Sigma", "SqrtSigma", "P", "Q"))
  if(length(covariance_list) == 0) stop(list_name, " must have at least one element")
  
  cov_val <- function(x){
    if(!is.null(covariance_list[[x]])){
      if(!is.numeric(covariance_list[[x]]) && !is.list(covariance_list[[x]]))
        stop("All specified elements of ", list_name, " element ", x, " must be numeric or a list of matrices")
      if(is.list(covariance_list[[x]])){
        if(!all(sapply(covariance_list[[x]], is.matrix)) || !all(sapply(covariance_list[[x]], is.numeric)))
          stop("All elements of list specification must be matrices")
      } else {
        if(is.matrix(covariance_list[[x]])){
          validate_sqmat(covariance_list[[x]], n,
                         message = c("Error in validating ", list_name, " element ", x, " (length>1): "))
        } else {
          if(length(covariance_list[[x]]) != 1 && length(covariance_list[[x]]) != n){
            stop("Invalid covariance vector length")
          } else {
            if(any(covariance_list[[x]] <= 0)) stop("Elements of a vector specification for covariance must be positive")
          }
        }
      }
    } 
  }

  lapply(names(covariance_list), cov_val)
  
  if(!is.null(covariance_list[["Sigma"]])){
    validate_symmetric(covariance_list[["Sigma"]], name = "Sigma",
                       sym_tol = sym_tol, sym_tol1 = sym_tol1)
  }
  if(!is.null(covariance_list[["P"]])){
    validate_symmetric(covariance_list[["P"]], name = "P",
                       sym_tol = sym_tol, sym_tol1 = sym_tol1)
  }
}
