validate_function_behavior <- function(f, X, n, theta){
  theta_char <- deparse1(substitute(theta))
  f_char <- deparse1(substitute(f))
  f_out <- tryCatch(f2ftheta(f = f, X = X[,, drop = FALSE], n = n)(theta),
                    error = function(e) stop("Unable to evaluate ", f_char, "(X, ",
                    theta_char, "): ", e))
  validate_numeric(x = f_out, len = n, message = "Function output failed numeric validation: ")
  
  if(!missing(theta) && !is.null(theta)){
    ftheta <- f2ftheta(f = f, X = X[1,, drop = FALSE], n = n)
    for(i in seq_along(theta)){
      theta_na <- theta
      theta_na[i] <- NA
      f_out <- tryCatch(ftheta(theta_na), error = function(e) return(e))
      if(!is(f_out, "error") && all(!is.na(f_out)))
        stop("Element ", i, " of ", theta_char, " unnecessary for function evaluation. ",
             "Recode ", f_char, ", or shorten ", theta_char, ", and retry.")
    }
  }
}
