% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dst_gp.R
\name{dst_gp}
\alias{dst_gp}
\title{Generalised Pareto Distribution}
\usage{
dst_gp(scale, shape)
}
\arguments{
\item{scale}{Scale parameter; single positive numeric.}

\item{shape}{Shape parameter; single positive numeric.
This is also the extreme value index, so that \code{shape > 0} is heavy
tailed, and \code{shape < 0} is short-tailed.}
}
\value{
A Generalised Pareto Distribution.
}
\description{
Makes a Generalized Pareto (GP) distribution, corresponding to the
limiting distribution of excesses over a threshold.
}
\examples{
# Short-tailed example
short <- dst_gp(1, -1)
range(short)
mean(short)

# Heavy-tailed example
heavy <- dst_gp(1, 1)
range(heavy)
mean(heavy)

# Light-tailed example (a Gumbel distribution)
light <- dst_gp(1, 0)
range(light)
mean(light)
}
