% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_poisson_inverse_gaussian.R
\name{dist_poisson_inverse_gaussian}
\alias{dist_poisson_inverse_gaussian}
\title{The Poisson-Inverse Gaussian distribution}
\usage{
dist_poisson_inverse_gaussian(mean, shape)
}
\arguments{
\item{mean, shape}{parameters. Must be strictly positive. Infinite
    values are supported.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Poisson-Inverse Gaussian distribution is a compound Poisson distribution
where the rate parameter follows an Inverse Gaussian distribution. It is
useful for modeling overdispersed count data.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_poisson_inverse_gaussian.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_poisson_inverse_gaussian.html}

In the following, let \eqn{X} be a Poisson-Inverse Gaussian random variable
with parameters \code{mean} = \eqn{\mu} and \code{shape} = \eqn{\phi}.

\strong{Support}: \eqn{\{0, 1, 2, 3, ...\}}{{0, 1, 2, 3, ...}}

\strong{Mean}: \eqn{\mu}

\strong{Variance}: \eqn{\frac{\mu}{\phi}(\mu^2 + \phi)}{\mu/\phi (\mu^2 + \phi)}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = x) = \frac{e^{\phi}}{\sqrt{2\pi}}
    \left(\frac{\phi}{\mu^2}\right)^{x/2}
    \frac{1}{x!}
    \int_0^\infty u^{x-1/2}
    \exp\left(-\frac{\phi u}{2} - \frac{\phi}{2\mu^2 u}\right) du
  }{
    P(X = x) = (e^\phi / sqrt(2\pi)) (\phi/\mu^2)^(x/2) (1/x!)
    \int_0^\infty u^(x-1/2) exp(-\phi u/2 - \phi/(2\mu^2 u)) du
  }

for \eqn{x = 0, 1, 2, \ldots}{x = 0, 1, 2, ...}

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le x) = \sum_{k=0}^{\lfloor x \rfloor} P(X = k)
  }{
    P(X <= x) = sum_{k=0}^x P(X = k)
  }

The c.d.f does not have a closed form and is approximated numerically.

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \exp\left\{\phi\left[1 - \sqrt{1 - \frac{2\mu^2}{\phi}(e^t - 1)}\right]\right\}
  }{
    E(e^(tX)) = exp{\phi [1 - sqrt(1 - 2\mu^2/\phi (e^t - 1))]}
  }

for \eqn{t < -\log(1 + \phi/(2\mu^2))}{t < -log(1 + \phi/(2\mu^2))}
}
\examples{
dist <- dist_poisson_inverse_gaussian(mean = rep(0.1, 3), shape = c(0.4, 0.8, 1))
dist

\dontshow{if (requireNamespace("actuar", quietly = TRUE)) withAutoprint(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[actuar:PoissonInverseGaussian]{actuar::PoissonInverseGaussian}, \code{\link[actuar:PoissonInverseGaussian]{actuar::dpoisinvgauss()}},
\code{\link[actuar:PoissonInverseGaussian]{actuar::ppoisinvgauss()}}, \code{\link[actuar:PoissonInverseGaussian]{actuar::qpoisinvgauss()}}, \code{\link[actuar:PoissonInverseGaussian]{actuar::rpoisinvgauss()}}
}
