% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HyperGeometric.R
\name{quantile.HyperGeometric}
\alias{quantile.HyperGeometric}
\title{Determine quantiles of a HyperGeometric distribution}
\usage{
\method{quantile}{HyperGeometric}(x, probs, drop = TRUE, elementwise = NULL, ...)
}
\arguments{
\item{x}{A \code{HyperGeometric} object created by a call to \code{\link[=HyperGeometric]{HyperGeometric()}}.}

\item{probs}{A vector of probabilities.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{x} be evaluated
at all elements of \code{probs} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{x} and \code{probs} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{...}{Arguments to be passed to \code{\link[stats]{qhyper}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(probs)} columns (if \code{drop = FALSE}). In case of a vectorized
distribution object, a matrix with \code{length(probs)} columns containing all
possible combinations.
}
\description{
Determine quantiles of a HyperGeometric distribution
}
\examples{

set.seed(27)

X <- HyperGeometric(4, 5, 8)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other HyperGeometric distribution: 
\code{\link{cdf.HyperGeometric}()},
\code{\link{pdf.HyperGeometric}()},
\code{\link{random.HyperGeometric}()}
}
\concept{HyperGeometric distribution}
