% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HyperGeometric.R
\name{random.HyperGeometric}
\alias{random.HyperGeometric}
\title{Draw a random sample from a HyperGeometric distribution}
\usage{
\method{random}{HyperGeometric}(x, n = 1L, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{HyperGeometric} object created by a call to \code{\link[=HyperGeometric]{HyperGeometric()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
In case of a single distribution object or \code{n = 1}, either a numeric
vector of length \code{n} (if \code{drop = TRUE}, default) or a \code{matrix} with \code{n} columns
(if \code{drop = FALSE}).
}
\description{
Please see the documentation of \code{\link[=HyperGeometric]{HyperGeometric()}} for some properties
of the HyperGeometric distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- HyperGeometric(4, 5, 8)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other HyperGeometric distribution: 
\code{\link{cdf.HyperGeometric}()},
\code{\link{pdf.HyperGeometric}()},
\code{\link{quantile.HyperGeometric}()}
}
\concept{HyperGeometric distribution}
