% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethod.R
\name{boutinit,data.frame-method}
\alias{boutinit,data.frame-method}
\alias{boutinit}
\alias{boutinit,Bouts-method}
\title{Fit "broken stick" model to log frequency data for identification of
bouts of behaviour}
\usage{
\S4method{boutinit}{data.frame}(obj, x.break, plot = TRUE, ...)

\S4method{boutinit}{Bouts}(obj, x.break, plot = TRUE, ...)
}
\arguments{
\item{obj}{Object of class \code{\link{Bouts}} or
\code{\link{data.frame}}.}

\item{x.break}{Numeric vector of length 1 or 2 with \code{x} value(s)
defining the break(s) point(s) for broken stick model, such that
\code{x} < \code{x.break}[1] is 1st process, and \code{x} >=
\code{x.break}[1] & \code{x} < \code{x.break}[2] is 2nd one, and
\code{x} >= \code{x.break}[2] is 3rd one.}

\item{plot}{logical, whether to plot results or not.}

\item{...}{arguments passed to \code{\link{plot}} (must exclude
\code{type}).}
}
\value{
(2,N) matrix with as many columns as the number of processes
    implied by \code{x.break} (i.e. \code{length(x.break) + 1}). Rows
    are named \code{a} and \code{lambda}, corresponding to starting
    values derived from broken stick model.  A plot is produced as a
    side effect if argument \code{plot} is \code{TRUE}.
}
\description{
Fits "broken stick" model to the log frequencies modelled as a function
of \var{x} (well, the midpoints of the binned data), using chosen
value(s) to separate the two or three processes.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: Fit "broken-stick" model on \code{data.frame}
object

\item \code{Bouts}: Fit "broken-stick" model on \code{Bouts} object
}}

\examples{
## 2-process
utils::example("rmixexp", package="diveMove", ask=FALSE)
## 'rndproc2' is a random sample vector from the example
xbouts2 <- boutfreqs(rndprocs2, 5)  # Bouts class result
(startval2 <- boutinit(xbouts2, 80))

## 3-process
## 'rndproc3' is a random sample vector from the example
xbouts3 <- boutfreqs(rndprocs3, 5)
(startval3 <- boutinit(xbouts3, c(75, 220)))
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
