% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_basis.R
\name{cross_basis}
\alias{cross_basis}
\title{Build crossbasis}
\usage{
cross_basis(
  x,
  M,
  L = NULL,
  argmod = list(),
  arglag = list(),
  model_type = "nonlinear"
)
}
\arguments{
\item{x}{a numeric time series vector of length n or matrix of lagged exposures (columns) for n individuals (rows)}

\item{M}{vector of length n containing modifier values}

\item{L}{a numeric vector of length 1 containing the number of lag terms. This is required if \code{x} is vector, and is not used if \code{x} is a matrix.}

\item{argmod}{a list: $fun is the spline function for the modifier ("ps" or "cr" to penalize), $arg is a list of arguments for the spline function (must be named by argument), $df is the degrees of freedom, $sp is optional smoothing parameter}

\item{arglag}{a list: $fun is the spline function for the lag ("ps" or "cr" to penalize), $arg is a list of arguments for the spline function (must be named by argument), $df is the degrees of freedom, $sp is optional smoothing parameter}

\item{model_type}{"linear" for a DLIM with linear interaction (linear modifier basis), "quadratic" for a DLIM with quadratic interaction (quadratic modifier basis), "nonlinear" for a DLIM with non-linear interaction (spline modifier basis)}
}
\value{
This function returns a list of 5 or 6 elements:
\item{cb }{cross-basis (matrix)}
\item{B_lag}{lag basis (basis matrix)}
\item{B_mod}{modifier basis (basis matrix)}
\item{df_l}{lag degrees of freedom (numeric)}
\item{df_m}{modifier degrees of freedom (numeric)}
\item{L}{number of lags (numeric)}
\item{Slist}{lag and modifier penalty matrices, if penalizing (list)}
}
\description{
Creates cross-basis using natural splines for regression in DLIM
}
\seealso{
\link[dlim]{dlim}

Type \code{vignette('dlimOverview')} for a detailed description.
}
