% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdlm.R
\name{pdlm}
\alias{pdlm}
\title{Build a Predictive Dynamic Linear Model (pdlm) for wastewater-based epidemiology}
\usage{
pdlm(
  data,
  formula,
  lags = 0,
  log10 = TRUE,
  date = NULL,
  prior = list(),
  equal.state.var = TRUE,
  equal.obs.var = TRUE,
  init_params = list(),
  auto_init = TRUE,
  control = list(maxit = 500)
)
}
\arguments{
\item{data}{A data frame containing the variables in the model.}

\item{formula}{An object of class "formula" describing the model to be fitted.}

\item{lags}{A nonnegative integer indicating the lag of the latent state in the model.}

\item{log10}{Logical; if TRUE, a log10 transformation is applied to the entire dataset.}

\item{date}{An optional vector of date indices of the data.}

\item{prior}{An optional list specifying the prior mean vector and covariance structure of the latent state.
If not provided, a naive prior is used.}

\item{equal.state.var}{Logical; if TRUE, the same variance is assumed across all state components.}

\item{equal.obs.var}{Logical; if TRUE, the same variance is assumed across all observation components.}

\item{init_params}{An optional list of initial parameters for the model. Should include Ft, Wt, and Vt:
transition coefficients, state variance, and observation variance components respectively.}

\item{auto_init}{Logical; if TRUE, naive initial parameters are used.}

\item{control}{An optional list of control parameters for \code{optim()}.}
}
\value{
A \code{dlm} object with additional attributes:
\describe{
\item{formula}{The fitted formula.}
\item{lags}{Number of lags.}
\item{data}{The input data.}
\item{date}{The input vector of dates.}
\item{parameters}{A list of estimated parameters.}
\item{logLik}{Log-likelihood of the fitted model.}
\item{aic}{Akaike Information Criterion.}
\item{bic}{Bayesian Information Criterion.}
\item{convergence}{The convergence code from \code{optim}.}
\item{model}{The final \code{dlm} object.}
\item{filter}{Output from \code{\link[dlm]{dlmFilter}}.}
\item{ypred}{One-step-ahead predictions.}
\item{var.pred}{Variance of the predictions.}
}
}
\description{
Constructs a dynamic linear model (DLM) object using the \pkg{dlm} package.
}
\examples{
\donttest{
data <- wastewaterhealthworker[wastewaterhealthworker$Code == "TC",]
data$SampleDate <- as.Date(data$SampleDate)
fit <- pdlm(
  formula=HealthWorkerCaseCount~WW.tuesday+WW.thursday,
  data = data,
  lags = 2,
  equal.state.var=FALSE,
  equal.obs.var=FALSE,
  log10=TRUE,
  date = "SampleDate")
summary(fit)
plot(fit, conf.int = TRUE)
}

}
