#' Build the transition matrix for Predictive Dynamic Linear Models (pdlm)
#'
#'
#' @param k the dimension of observation equation
#' @param lags a nonnegative integer indicating the number of lags in latent state.
#'
#' @return A matrix with proper dimension.
#'
#' @noRd


getGG <- function(k, lags){
  GG <- c(1, rep(x=0, times=(lags+1)*k ))
  n <- k*(lags+1)
  for(i in 1:n){
    m <- (i-1) %/% (lags+1)
    p <- m*(lags+1) + max(0, (i-1) %% (lags+1) -1)
    GG <- rbind(GG, c(0, rep(x=0, times=p), 1, rep(0, times=n-p-1)) )
  }
  return(GG)
}
