% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{read_or_process}
\alias{read_or_process}
\title{Read or Process a File}
\usage{
read_or_process(
  source_path,
  target_path,
  process_f = readRDS,
  process_args = NULL,
  read_f = readRDS,
  read_args = NULL,
  write_f = saveRDS,
  write_args = NULL,
  force_process = FALSE
)
}
\arguments{
\item{source_path}{Character scalar; the path to the raw file. Paths starting
with \code{http://}, \code{http://}, \code{http://}, or \code{http://} will
be downloaded to a temp file if the processed version is not already
available.}

\item{target_path}{Character scalar; the path where the processed version of
the file should be stored.}

\item{process_f}{A function or one-sided formula to use to process the source
file. \code{source_path} will be passed as the first argument to this
function. Defaults to \code{read_f}.}

\item{process_args}{An optional list of additional arguments to
\code{process_f}.}

\item{read_f}{A function or one-sided formula to use to read the processed
file. \code{target_path} will be passed as the first argument to this
function. Defaults to \code{\link[base]{readRDS}}.}

\item{read_args}{An optional list of additional arguments to \code{read_f}.}

\item{write_f}{A function or one-sided formula to use to save the processed
file. The processed object will be passed as the first argument to this
function, and \code{target_path} will be passed as the second argument.
Defaults to \code{\link[base]{saveRDS}}.}

\item{write_args}{An optional list of additional arguments to \code{write_f}.}

\item{force_process}{A logical scalar indicating whether we should process
the source file even if the target already exists. This can be particularly
useful if you wish to redownload a file.}
}
\value{
The processed object.
}
\description{
Often, a file must be processed before being usable in R. It can be useful to
save the processed contents of that file in a standard format, such as RDS,
so that the file does not need to be processed the next time it is loaded.
}
\examples{
if (interactive()) {
  temp_filename <- tempfile()
  austin_smoke_free <- read_or_process(
    "https://query.data.world/s/owqxojjiphaypjmlxldsp566lck7co",
    target_path = temp_filename,
    process_f = read.csv
  )
  head(austin_smoke_free)
}

# Calling the function a second time gives the result instantly.
if (interactive()) {
  austin_smoke_free <- read_or_process(
    "https://query.data.world/s/owqxojjiphaypjmlxldsp566lck7co",
    target_path = temp_filename,
    process_f = read.csv
  )
  head(austin_smoke_free)
}

if (interactive()) {
  # Remove the generated file.
  unlink(temp_filename)
}
}
