% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine_bayes.R
\name{engineEdgeBayes}
\alias{engineEdgeBayes}
\title{Implementation of simulation engine for dynamic networks using smoothing estimates of change statistics.}
\usage{
engineEdgeBayes(
  start_network,
  inputcoeff,
  ns,
  model.terms,
  model.formula,
  graph_mode,
  group,
  intercept,
  exvar,
  maxlag,
  lagmat,
  ylag,
  lambda = NA,
  method = "bayesglm",
  alpha.glmnet,
  paramout = TRUE,
  Theta = NA
)
}
\arguments{
\item{start_network}{Initial list of networks}

\item{inputcoeff}{coefficient vector}

\item{ns}{number of time points for simulation}

\item{model.terms}{model terms in formula}

\item{model.formula}{model formula (ergm)}

\item{graph_mode}{'digraph' by default}

\item{group}{group terms}

\item{intercept}{intercept terms}

\item{exvar}{extraneous covariates}

\item{maxlag}{maximum lag}

\item{lagmat}{lag matrix}

\item{ylag}{lag vector for network lag terms}

\item{lambda}{NA}

\item{method}{'bayesglm' by default}

\item{alpha.glmnet}{NA}

\item{paramout}{T/F parameter estimation is returned.}

\item{Theta}{= prior probability matrix.}
}
\description{
Implementation of simulation engine for dynamic networks using smoothing estimates of change statistics.
}
\examples{
\dontrun{
startNet <- rdNets[1:50]
model.terms=c("triadcensus.003", "triadcensus.012", "triadcensus.102", "triadcensus.021D", "gwesp")
model.formula = net~triadcensus(0:3)+gwesp(alpha=0, fixed=FALSE, cutoff=30)-1
graph_mode <- 'digraph'
group <- 'dnc'
alpha.glmnet <- 1
method <- 'bayesglm'
maxlag <- 3
lambda <- NA
intercept <- "edges"
cdim <- length(model.terms)
lagmat <- matrix(sample(c(0,1),(maxlag+1)*cdim,replace = TRUE),ncol = cdim)
ylag <- rep(1,maxlag)
lagmat[1,] <- rep(0,ncol(lagmat))

out.coef <- paramEdge(input_network = startNet,
                model.terms = model.terms,
                model.formula = model.formula,
                graph_mode='digraph',
                group=group,intercept = intercept,
                exvar=NA,
                maxlag = maxlag,
                lagmat = lagmat,
                ylag = ylag,
                lambda = NA, method='bayesglm',
                alpha.glmnet=1)


inputcoeff <- out.coef$coef$coef.edge
nvertex <- 47 ##find vertex here
ns <- 1
exvar <- NA
for(i in seq_along(startNet)) Theta <- Theta + startNet[[i]][,]
Theta <- Theta/length(startNet)
Theta <- thresh(Theta)
out.bayes <- engineEdgeBayes(start_network=startNet,
inputcoeff=inputcoeff,
ns=ns,
model.terms=model.terms,
model.formula=model.formula,
graph_mode=graph_mode,
group=group,intercept=intercept,
exvar=exvar,
maxlag=maxlag,
lagmat=lagmat,
ylag=ylag,
lambda = NA, method='bayesglm',
alpha.glmnet=alpha.glmnet,
Theta = Theta)
}
}
