% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docorate.R
\name{as_docorator}
\alias{as_docorator}
\title{Create docorator object}
\usage{
as_docorator(
  x,
  display_name,
  display_loc = NULL,
  header = fancyhead(fancyrow(right = doc_pagenum())),
  footer = fancyfoot(fancyrow(left = doc_path(display_name, display_loc), right =
    doc_datetime())),
  save_object = TRUE,
  object_loc = display_loc,
  ...,
  fontsize = 10,
  geometry = geom_set(),
  fig_dim = c(5, 8),
  tbl_scale = TRUE,
  tbl_stub_pct = 0.3
)
}
\arguments{
\item{x}{object containing the display. See @details for more information.}

\item{display_name}{required name of file (excluding extension)}

\item{display_loc}{optional path to save the output file to}

\item{header}{Document header. Accepts a \code{fancyhead} object. If \code{NULL}, no header will be displayed.}

\item{footer}{Document footer Accepts a \code{fancyfoot} object. If \code{NULL}, no footer will be displayed.}

\item{save_object}{Boolean indicating if a docorator object should be saved.}

\item{object_loc}{path for the docorator object -  defaults to display_loc argument.}

\item{...}{These dots are for future extensions and must be empty.}

\item{fontsize}{Font size (pt). Defaults to \code{10}. Accepted values: 10, 11, 12.}

\item{geometry}{Document sizing options based on the \code{geometry} latex
package. Accepts a named list. Default is \code{geom_set()}.}

\item{fig_dim}{vector containing figure height and width in inches. Defaults
to \code{c(5,8)}}

\item{tbl_scale}{Boolean for whether or not to automatically scale table columns to fit display area. Defaults to TRUE. Note that this will overwrite scaling set in the table directly unless set to FALSE.}

\item{tbl_stub_pct}{percent of total width that should be dedicated to stub column(s). If more than 1 stub column then this is the total for both.}
}
\value{
docorator object
}
\description{
Create docorator object
}
\details{
While the \code{x} argument flexibly accepts many different R objects, the
following classes/types are recommended:
\itemize{
\item \code{gt}
\item \code{gt_group} (list of \code{gt} objects)
\item \code{ggplot}
\item list of \code{ggplot}s
\item path to PNG file created via \code{png_path()}
\item list of paths to PNG files created via \code{png_path()}
}
}
\examples{

\dontrun{
gt::gtcars |>
  dplyr::slice_head(n = 10) |>
  dplyr::select(mfr, model, year, msrp) |>
  gt::gt(groupname_col = "mfr",
         row_group_as_column = TRUE) |>
  as_docorator(
   header = fancyhead(fancyrow("Header 1"), fancyrow("Header 2")),
   display_name = "mytbl",
   footer = NULL)
}

}
