% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_brackets.R
\name{add_brackets}
\alias{add_brackets}
\title{Add Labelled Brackets to Group Predictors in a Dot-and-Whisker Plot}
\usage{
add_brackets(p, brackets, fontSize = 0.7, face = "italic", ...)
}
\arguments{
\item{p}{A plot generated by \code{dwplot}.  Any `ggplot` customization should be done before passing the plot to \code{add_brackets}.  To pass the finalized plot to \code{add_brackets} without creating an intermediate object, simply wrap the code that generates it in braces (\code{`{`} and \code{`}`}).}

\item{brackets}{A list of brackets; each element of the list should be a character vector consisting of (1) a label for the bracket, (2) the name of the topmost variable to be enclosed by the bracket, and (3) the name of the bottom most variable to be enclosed by the bracket.}

\item{fontSize}{A number defining the size of the bracket label. The default value is .7.}

\item{face}{A typeface for the bracket labels; options are "plain", "bold", "italic", "oblique", and "bold.italic".}

\item{\dots}{Extra arguments to pass to \code{\link[grid]{gpar}}.}
}
\value{
The function returns a \code{ggplot} object.
}
\description{
\code{add_brackets} draws brackets along the y-axis beyond the plotting area of a dot-and-whisker plot generated by \code{dwplot}, useful for labelling groups of predictors
}
\details{
The brackets are drawn by `grid` functions. Apart from font size and typeface, users can customize the appearance of the bracket labels by setting `gpar` arguments in `add_brackets`.
}
\examples{
library(dplyr)
m1 <- lm(mpg ~ wt + cyl + disp, data = mtcars)
two_brackets <- list(c("Engine", "Cylinder", "Displacement"),
                     c("Not Engine", "Intercept", "Weight"))

{dwplot(m1, show_intercept = TRUE) \%>\%
       relabel_predictors("(Intercept)" = "Intercept",
                          wt = "Weight",
                          cyl = "Cylinder",
                          disp = "Displacement") +
       theme_bw() + xlab("Coefficient") + ylab("") +
       theme(legend.position="none") +
       geom_vline(xintercept = 0, colour = "grey50", linetype = 2)} \%>\%
   add_brackets(two_brackets)

}
