% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeFunctions.R
\name{findSwitches}
\alias{findSwitches}
\title{Create a bootstrap distribution for clone sequence alignments, and estimate 
trees for each bootstrap replicate.}
\usage{
findSwitches(
  clones,
  permutations,
  trait,
  igphyml,
  fixtrees = FALSE,
  downsample = TRUE,
  tip_switch = 20,
  nproc = 1,
  dir = NULL,
  id = NULL,
  modelfile = NULL,
  build = "pratchet",
  exec = NULL,
  quiet = 0,
  rm_temp = TRUE,
  palette = NULL,
  resolve = 2,
  rep = NULL,
  keeptrees = FALSE,
  lfile = NULL,
  seq = NULL,
  boot_part = "locus",
  force_resolve = FALSE,
  ...
)
}
\arguments{
\item{clones}{tibble \code{airrClone} objects, the output of 
\link{formatClones}}

\item{permutations}{number of bootstrap replicates to perform}

\item{trait}{trait to use for parsimony models}

\item{igphyml}{location of igphyml executable}

\item{fixtrees}{keep tree topologies fixed?
(bootstrapping will not be performed)}

\item{downsample}{downsample clones to have a maximum specified tip/switch ratio?}

\item{tip_switch}{maximum allowed tip/switch ratio if downsample=TRUE}

\item{nproc}{number of cores to parallelize computations}

\item{dir}{directory where temporary files will be placed (required
if \code{igphyml} or \code{dnapars} specified)}

\item{id}{unique identifier for this analysis (required if 
\code{igphyml} or \code{dnapars} specified)}

\item{modelfile}{file specifying parsimony model to use}

\item{build}{program to use for tree building (phangorn, dnapars)}

\item{exec}{location of desired phylogenetic executable}

\item{quiet}{amount of rubbish to print to console}

\item{rm_temp}{remove temporary files (default=TRUE)}

\item{palette}{deprecated}

\item{resolve}{how should polytomies be resolved? 
0=none, 1=max parsimony, 2=max ambiguity + polytomy skipping,
3=max ambiguity}

\item{rep}{current bootstrap replicate (experimental)}

\item{keeptrees}{keep trees estimated from bootstrap replicates? (TRUE)}

\item{lfile}{lineage file input to igphyml if desired (experimental)}

\item{seq}{column name containing sequence information}

\item{boot_part}{is  "locus" bootstrap columns for each locus separately}

\item{force_resolve}{continue even if polytomy resolution fails?}

\item{...}{additional arguments to be passed to tree building program}
}
\value{
A list of trees and/or switch counts for each bootstrap replicate.
}
\description{
\code{findSwitches} Phylogenetic bootstrap function.
}
\details{
Tree building details are the same as \link{getTrees}. 
If \code{keeptrees=TRUE} (default) the returned object will contain a list 
named "trees" which contains a list of estimated tree objects for each 
bootstrap replicate. The object is structured like: 
trees[[<replicate>]][[<tree index>]]. If \code{igphyml} is specified 
(as well as \code{trait}), the returned object 
will contain a \code{tibble} named "switches" containing switch count 
information. This object can be passed to \link{testSP} and other functions 
to perform parsimony based trait value tests. 

Trait values cannot contain values N, UCA, or NTIP. These are reserved for
use by test statistic functions.
}
\examples{
\dontrun{
data(ExampleAirr)
ExampleAirr$sample_id <- sample(ExampleAirr$sample_id)
clones <- formatClones(ExampleAirr, trait="sample_id")

igphyml <- "~/apps/igphyml/src/igphyml"
btrees <- findSwitches(clones[1:2,], permutations=10, nproc=1,
   igphyml=igphyml, trait="sample_id")
plotTrees(btrees$trees[[4]])[[1]]
testPS(btrees$switches)
}
}
\seealso{
Uses output from \link{formatClones} with similar arguments to 
\link{getTrees}. Output can be visualized with \link{plotTrees}, and tested
with \link{testPS}, \link{testSC}, and \link{testSP}.
}
