% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Company.R
\name{dpd_company}
\alias{dpd_company}
\title{Company}
\usage{
dpd_company(id, lang = c("en", "fr"))
}
\arguments{
\item{id}{Company code.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{city_name}: City name.
\item \code{company_code}: Code assigned to a company.
\item \code{company_name}: Company name.
\item \code{company_type}: Company type.
\item \code{country_name}: Country name.
\item \code{post_office_box}: P.O. box number (if applicable).
\item \code{postal_code}: Postal code.
\item \code{province_name}: Province name.
\item \code{street_name}: Street name.
\item \code{suite_number}: Suite number.
}
}
\description{
Company information associated with a company code.
}
\details{
In the DPD, a product may have several companies associated with them. Each
product will have a DIN Owner associated with it. If a DIN Owner has
designated another company to receive their mailing, their name and
address will also be included and can be identified with a 'Y' flag in the
ADDRESS_MAILING_FLAG field.

The company contact information is not included in the API (ATTENTION_TO,
LANGUAGE, TELEPHONE_NUMBER, FAX_NUMBER, EMAIL_ADDRESS). The contact
information in the database is generally a representative from the
Regulatory Affairs department. It has come to our attention that some
users are contacting these individuals to make general inquiries, we would
like to recommend not doing so.
}
\examples{
dpd_company(10825)
}
