% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DosageForm.R
\name{dpd_dosage_form}
\alias{dpd_dosage_form}
\title{Dosage Form}
\usage{
dpd_dosage_form(id, active = FALSE, lang = c("en", "fr"))
}
\arguments{
\item{id}{Drug product code.}

\item{active}{Only return dosage forms that are active? Default is \code{FALSE}.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{drug_code}: Code assigned to each drug product.
\item \code{pharmaceutical_form_code}: Code assigned to a dosage form.
\item \code{pharmaceutical_form_name}: Dosage form.
}
}
\description{
The dosage form is the form of presentation in which the product is supplied,
for example, tablet, capsule, powder, etc.
}
\details{
A product can have more than one dosage form when it is a kit
(e.g. tablet, capsule).
}
\examples{
dpd_dosage_form(10846)
}
