% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RouteOfAdmin.R
\name{dpd_route_of_admin}
\alias{dpd_route_of_admin}
\title{Route of Administration}
\usage{
dpd_route_of_admin(id, active = FALSE, lang = c("en", "fr"))
}
\arguments{
\item{id}{Drug product code.}

\item{active}{Only return dosage forms that are active? Default is \code{FALSE}.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{drug_code}: Code assigned to each drug product.
\item \code{route_of_administration_code}: Code assigned to a route of
administration.
\item \code{route_of_administration_name}: Route of administration.
}
}
\description{
Indicates the part of the body on which, through which or into which the
product is to be introduced (e.g. oral, topical, intramuscular, rectal).
}
\details{
A product can have more than one route of administration
(e.g. intravenous, intramuscular, intra-articular).
}
\examples{
dpd_route_of_admin(3)
}
