% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-data.R
\name{group_data}
\alias{group_data}
\alias{group_keys}
\alias{group_rows}
\alias{group_indices}
\alias{group_vars}
\alias{groups}
\alias{group_size}
\alias{n_groups}
\title{Grouping metadata}
\usage{
group_data(.data)

group_keys(.tbl, ...)

group_rows(.data)

group_indices(.data, ...)

group_vars(x)

groups(x)

group_size(x)

n_groups(x)
}
\arguments{
\item{.data, .tbl, x}{A data frame or extension (like a tibble or grouped
tibble).}

\item{...}{Unused.}
}
\description{
This collection of functions accesses data about grouped data frames in
various ways:
\itemize{
\item \code{group_data()} returns a data frame that defines the grouping structure.
The columns give the values of the grouping variables. The last column,
always called \code{.rows}, is a list of integer vectors that gives the
location of the rows in each group.
\item \code{group_keys()} returns a data frame describing the groups.
\item \code{group_rows()} returns a list of integer vectors giving the rows that
each group contains.
\item \code{group_indices()} returns an integer vector the same length as \code{.data}
that gives the group that each row belongs to.
\item \code{group_vars()} gives names of grouping variables as character vector.
\item \code{groups()} gives the names of the grouping variables as a list of symbols.
\item \code{group_size()} gives the size of each group.
\item \code{n_groups()} gives the total number of groups.
}

See \link{context} for equivalent functions that return values for the \emph{current}
group.
}
\examples{
df <- tibble(x = c(1,1,2,2))
group_vars(df)
group_rows(df)
group_data(df)
group_indices(df)

gf <- group_by(df, x)
group_vars(gf)
group_rows(gf)
group_data(gf)
group_indices(gf)
}
\keyword{internal}
