% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{effective_dose}
\alias{effective_dose}
\title{Effective dose}
\usage{
effective_dose(object, y, type, level)
}
\arguments{
\item{object}{fit object as returned by \code{\link[drda]{drda}}.}

\item{y}{numeric vector with response levels (default 0.5).}

\item{type}{character string with either "relative" (default) or "absolute".}

\item{level}{level of confidence intervals (default 0.95).}
}
\value{
Numeric matrix with the effective doses and the corresponding
confidence intervals. Each row is associated with each value of \code{y}.
}
\description{
Estimate effective doses, that is the \code{x} values for which \code{f(x) = y}.
}
\details{
Given a fitted model \verb{f(x; theta)} we seek the values \code{x} at which the
function is equal to the specified response values.

If responses are given on a relative scale (\code{type = "relative"}), then \code{y} is
expected to range in the interval \verb{(0, 1)}.

If responses are given on an absolute scale (\code{type = "absolute"}), then \code{y}
is free to vary on the whole real line. Note, however, that the solution
does not exist when \code{y} is not in the image of the function.
}
\examples{
drda_fit <- drda(response ~ log_dose, data = voropm2)
effective_dose(drda_fit)

# relative values are given on the (0, 1) range
effective_dose(drda_fit, y = c(0.2, 0.8))

# explicitly say when we are using actual response values
effective_dose(drda_fit, y = c(0.2, 0.8), type = "absolute")

# use a different confidence level
effective_dose(drda_fit, y = 0.6, level = 0.8)
}
