% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic4.R
\name{loglogistic4_gradient_2}
\alias{loglogistic4_gradient_2}
\alias{loglogistic4_hessian_2}
\alias{loglogistic4_gradient_hessian_2}
\title{4-parameter log-logistic function gradient and Hessian}
\usage{
loglogistic4_gradient_2(x, theta)

loglogistic4_hessian_2(x, theta)

loglogistic4_gradient_hessian_2(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Gradient or Hessian of the alternative parameterization evaluated at
the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
4-parameter log-logistic function.
}
\details{
The 4-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = x^eta / (x^eta + phi^eta)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi, nu)}, \code{eta > 0}, and
\code{phi > 0}.

This set of functions use a different parameterization from
\code{link[drda]{loglogistic4_gradient}}. To avoid the non-negative
constraints of parameters, the gradient and Hessian computed here are for
the function with \code{eta2 = log(eta)} and \code{phi2 = log(phi)}.

Note that argument \code{theta} is on the original scale and not on the log scale.
}
