% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic5.R
\name{loglogistic5_fn}
\alias{loglogistic5_fn}
\title{5-parameter log-logistic function}
\usage{
loglogistic5_fn(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the five parameters in the form
\code{c(alpha, delta, eta, phi, nu)}.}
}
\value{
Numeric vector of the same length of \code{x} with the values of the
log-logistic function.
}
\description{
Evaluate at a particular set of parameters the 5-parameter log-logistic
function.
}
\details{
The 5-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = (x^eta / (x^eta + nu * phi^eta))^(1 / nu)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi, nu)}, \code{eta > 0},
\code{phi > 0}, and \code{nu > 0}.

Parameter \code{alpha} is the value of the function when \code{x = 0}.
Parameter \code{delta} is the (signed) height of the curve.
Parameter \code{eta} represents the steepness (growth rate) of the curve.
Parameter \code{phi} is related to the mid-value of the function.
Parameter \code{nu} affects near which asymptote maximum growth occurs.
}
