% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onemode_PIB.R
\name{computeLealBrokerage}
\alias{computeLealBrokerage}
\title{Compute Potential for Cultural Brokerage (PIB) Based on Leal (2025)}
\usage{
computeLealBrokerage(
  net,
  g.mem,
  symmetric = TRUE,
  triad.type = NULL,
  count = TRUE,
  isolate = NA
)
}
\arguments{
\item{net}{The one-mode adjacency matrix.}

\item{g.mem}{The vector of membership values that the brokerage scores will be based on.}

\item{symmetric}{TRUE/FALSE. TRUE indicates that network matrix will be treated as symmetric. FALSE indicates that the network matrix will be treated as asymmetric. Set to TRUE by default.}

\item{triad.type}{The string value (or vector) that indicates what specific triadic (star) structures the potential for cultural brokerage will be computed for. Possible values are "ANY", "OTS", "ITS", "MTS" (see the details section). The function defaults to “ANY”.}

\item{count}{TRUE/FALSE. TRUE indicates that the number of culturally brokered open triangles will be returned. FALSE indicates that the proportion of culturally brokered open triangles to all open triangles will be returned (see the details section). Set to TRUE by default.}

\item{isolate}{If count = FALSE, the numerical value that will be given to isolates. This value is set to NA by default, as 0/0 is undefined. The user can specify this value!}
}
\value{
The vector of interpersonal cultural brokerage values for the one-mode network.
}
\description{
Following Leal (2025), this function calculates node’s Potential
for Intercultural Brokerage (PIB) in a one-mode network. For example, users can
examine PIB across gender. The option count determines what is returned by the
function. If count is true, then the count of culturally dissimilar pairs
brokered by ego is included (i.e., ego’s total count of brokered open triangles
where the alters at the two endpoints of said open triangles are culturally
dissimilar from one another). If count is false, the proportion of ego’s
brokered open triangles where the endpoints are culturally dissimilar out of
all of ego’s brokered open triangles (regardless of the cultural identity of
the alters) is returned. The formula for computing interpersonal brokerage is
presented in the details section.
}
\details{
Following Leal (2025), the formula for interpersonal brokerage is:

\deqn{ \text{PIB}_i = \sum_{j < k} \frac{S_{jik}}{S_{jk}} m_{jk}, \quad S_{jik} \neq 0 \text{ and } i \neq j \neq k }

where:
\itemize{
\item \eqn{S_{jik} = 1} if there is an (un)directed two-path connecting actors \emph{j} and \emph{k} through actor \emph{i}; 0 otherwise.
\item \eqn{m_{jk} = 1} if actors \emph{j} and \emph{k} are on different sides of a symbolic boundary; 0 otherwise.
\item Following Gould (1989), \eqn{S_{jik}} represents the total number of two-paths between actors \emph{j} and \emph{k}.
}
If the network is non-symmetric (i.e., the user specified symmetric = FALSE), then
the function can compute the cultural brokerage scores for different star structures. The possible
values are: "ANY", which computes the scores for all structures, where a tie exists
between \emph{i} and \emph{j}, \emph{j} and \emph{k}, and one does not exist between \emph{i} and \emph{k}. "OTS" computes the
values for outgoing two-stars (i<-j->k or the 021D triad according to the M.A.N. notation; see Wasserman and Faust 1994), where j is the broker. "ITS" computes the
values for incoming two-stars (i->j<-k or the 021U triad according to the M.A.N. notation; see Wasserman and Faust 1994 ), where j is the broker. "MTS" computes PIB for
mixed triadic structures (i<-j<-k or i->j->k or the 021C triad according to the M.A.N. notation; see Wasserman and Faust 1994). If not specified, the function defaults to the
"ANY" category. This function can also compute all of the formations at once.
}
\examples{

# For this example, we recreate Figure 3 in Leal (2025)
LealNet <- matrix( c(
 0,1,0,0,0,0,0,
 1,0,1,1,0,0,0,
 0,1,0,0,1,1,0,
 0,1,0,0,1,0,0,
 0,0,1,1,0,0,0,
 0,0,1,0,0,0,1,
 0,0,0,0,0,1,0),
 nrow = 7, ncol = 7, byrow = TRUE)

colnames(LealNet) <- rownames(LealNet) <- c("A", "B", "C","D",
                                           "E", "F", "G")
categorical_variable <- c(0,0,1,0,0,0,0)
#These values are exactly the same as reported by Leal (2025)
computeLealBrokerage(LealNet,
   symmetric = TRUE,
   g.mem = categorical_variable)



}
\references{
Gould, Roger. 1989. "Power and Social Structure in Community Elites." \emph{Social Forces} 68(2): 531-552.

Leal, Diego F. 2025. "Locating Cultural Holes Brokers in Diffusion Dynamics Across Bright Symbolic Boundaries." \emph{Sociological Methods & Research} \doi{10.1177/00491241251322517}

Wasserman, Stanley and Katherine Faust. 1994. \emph{Social Network Analysis: Methods and Applications}. Cambridge: Cambridge University Press.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
