% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_bias.R
\name{optimal_bias}
\alias{optimal_bias}
\title{Optimal phase II/III drug development planning for time-to-event endpoints
when discounting phase II results}
\usage{
optimal_bias(
  w,
  hr1,
  hr2,
  id1,
  id2,
  d2min,
  d2max,
  stepd2,
  hrgomin,
  hrgomax,
  stephrgo,
  adj = "both",
  lambdamin = NULL,
  lambdamax = NULL,
  steplambda = NULL,
  alphaCImin = NULL,
  alphaCImax = NULL,
  stepalphaCI = NULL,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  steps1 = 1,
  stepm1 = 0.95,
  stepl1 = 0.85,
  b1,
  b2,
  b3,
  fixed = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior
distribution, see the \href{https://sterniii3.github.io/drugdevelopR/articles/Introduction-to-drugdevelopR.html}{vignette on priors}
as well as the \href{https://web.imbi.uni-heidelberg.de/prior/}{Shiny app} for
more details concerning the definition of a prior distribution.}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{d2min}{minimal number of events for phase II}

\item{d2max}{maximal number of events for phase II}

\item{stepd2}{stepsize for the optimization over \code{d2}}

\item{hrgomin}{minimal threshold value for the go/no-go decision rule}

\item{hrgomax}{maximal threshold value for the go/no-go decision rule}

\item{stephrgo}{stepsize for the optimization over HRgo}

\item{adj}{choose type of adjustment: \code{"multiplicative"},
\code{"additive"}, \code{"both"} or \code{"all"}. When using "both",
\code{res[1,]} contains the results using the multiplicative method and \code{res[2,]}
contains the results using the additive method. When using "all", there are
also \code{res[3,]} and \code{res[4,]}, containing the results of a multiplicative
and an additive method which do not only adjust the treatment effect but
also the threshold value for the decision rule.}

\item{lambdamin}{minimal multiplicative adjustment parameter lambda (i.e. use estimate with a retention factor)}

\item{lambdamax}{maximal multiplicative adjustment parameter lambda (i.e. use estimate with a retention factor)}

\item{steplambda}{stepsize for the adjustment parameter lambda}

\item{alphaCImin}{minimal additive adjustment parameter alphaCI (i.e. adjust the lower bound of the one-sided confidence interval)}

\item{alphaCImax}{maximal additive adjustment parameter alphaCI (i.e. adjust the lower bound of the one-sided confidence interval)}

\item{stepalphaCI}{stepsize for alphaCI}

\item{alpha}{one-sided significance level}

\item{beta}{1-beta power for calculation of the number of events for phase III by Schoenfeld (1981) formula}

\item{xi2}{event rate for phase II}

\item{xi3}{event rate for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $}

\item{c3}{variable per-patient cost for phase III in 10^5 $}

\item{c02}{fixed cost for phase II in 10^5 $}

\item{c03}{fixed cost for phase III in 10^5 $}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g., no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g., no constraint}

\item{steps1}{lower boundary for effect size category "small" in HR scale, default: 1}

\item{stepm1}{lower boundary for effect size category "medium" in HR scale = upper boundary for effect size category "small" in HR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category "large" in HR scale = upper boundary for effect size category "medium" in HR scale, default: 0.85}

\item{b1}{expected gain for effect size category "small" in 10^5 $}

\item{b2}{expected gain for effect size category "medium" in 10^5 $}

\item{b3}{expected gain for effect size category "large" in 10^5 $}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE hr1 is used as fixed effect}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{Method}{Type of adjustment: "multipl." (multiplicative adjustment of effect size), "add." (additive adjustment of effect size), "multipl2." (multiplicative adjustment of effect size and threshold), "add2." (additive adjustment of effect size and threshold)}
\item{Adj}{optimal adjustment parameter (lambda or alphaCI according to Method)}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{HRgo}{optimal threshold value for the decision rule to go to phase III}
\item{d2}{optimal total number of events for phase II}
\item{d3}{total expected number of events for phase III; rounded to next natural number}
\item{d}{total expected number of events in the program; d = d2 + d3}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg1}{probability of a successful program with "small" treatment effect in phase III}
\item{sProg2}{probability of a successful program with "medium" treatment effect in phase III}
\item{sProg3}{probability of a successful program with "large" treatment effect in phase III}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish time of the optimization procedure. The attribute
\code{attr(,"trace")} returns the utility values of all parameter
combinations visited during optimization.
}
\description{
The function \code{\link{optimal_bias}} of the drugdevelopR package enables planning of phase II/III drug development programs with optimal sample size allocation and go/no-go decision rules including methods for discounting of phase II results for time-to-event endpoints (Preussler et. al, 2020).
The discounting may be necessary as programs that proceed to phase III can be overoptimistic about the treatment effect (i.e. they are biased).
The assumed true treatment effects can be assumed fixed (planning is then also possible via user friendly R Shiny App: \href{https://web.imbi.uni-heidelberg.de/bias/}{bias}) or modelled by a prior distribution.
The R Shiny application \href{https://web.imbi.uni-heidelberg.de/prior/}{prior} visualizes the prior distributions used in this package.
Fast computing is enabled by parallel programming.
}
\examples{
# Activate progress bar (optional)
\dontrun{
progressr::handlers(global = TRUE)
}
# Optimize
\donttest{
optimal_bias(w = 0.3,                       # define parameters for prior
  hr1 = 0.69, hr2 = 0.88, id1 = 210, id2 = 420,      # (https://web.imbi.uni-heidelberg.de/prior/)
  d2min = 20, d2max = 100, stepd2 = 5,               # define optimization set for d2
  hrgomin = 0.7, hrgomax = 0.9, stephrgo = 0.05,     # define optimization set for HRgo
  adj = "both",                                      # choose type of adjustment
  lambdamin = 0.2, lambdamax = 1, steplambda = 0.05, # define optimization set for lambda
  alphaCImin = 0.025, alphaCImax = 0.5,
  stepalphaCI = 0.025,                               # define optimization set for alphaCI
  alpha = 0.025, beta = 0.1, xi2 = 0.7, xi3 = 0.7,   # drug development planning parameters
  c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,           # fixed/variable costs for phase II/III
  K = Inf, N = Inf, S = -Inf,                        # set constraints
  steps1 = 1,                                        # define lower boundary for "small"
  stepm1 = 0.95,                                     # "medium"
  stepl1 = 0.85,                                     # and "large" effect size categories
  b1 = 1000, b2 = 2000, b3 = 3000,                   # define expected benefits 
  fixed = FALSE,                                     # true treatment effects are fixed/random
  num_cl = 1)                                        # number of coresfor parallelized computing 
  }
}
\references{
IQWiG (2016). Allgemeine Methoden. Version 5.0, 10.07.2016, Technical Report. Available at \href{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}, last access 15.05.19.

Preussler, S., Kirchner, M., Goette, H., Kieser, M. (2020). Optimal designs for phase II/III drug development programs including methods for discounting of phase II results. Submitted to peer-review journal.

Schoenfeld, D. (1981). The asymptotic properties of nonparametric tests for comparing survival distributions. Biometrika, 68(1), 316-319.
}
