% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial.R
\name{utility_multitrial}
\alias{utility_multitrial}
\alias{utility2}
\alias{utility3}
\alias{utility4}
\title{Utility function for multitrial programs in a time-to-event setting}
\usage{
utility2(
  d2,
  HRgo,
  w,
  hr1,
  hr2,
  id1,
  id2,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)

utility3(
  d2,
  HRgo,
  w,
  hr1,
  hr2,
  id1,
  id2,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)

utility4(
  d2,
  HRgo,
  w,
  hr1,
  hr2,
  id1,
  id2,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)
}
\arguments{
\item{d2}{total number of events in phase II}

\item{HRgo}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{xi2}{event rate for phase II}

\item{xi3}{event rate for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{case}{choose case: "at least 1, 2 or 3 significant trials needed for approval"}

\item{fixed}{choose if true treatment effects are fixed or random}
}
\value{
The output of the functions \code{utility2()}, \code{utility3()} and \code{utility4()} is the expected utility of the program when 2, 3 or 4 phase III trials are performed.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in further step maximized by the \code{optimal_multitrial()} function.
}
\examples{
res <- utility2(d2 = 50, HRgo = 0.8,  w = 0.3, 
                                 hr1 =  0.69, hr2 = 0.81, 
                                 id1 = 210, id2 = 420, 
                                 alpha = 0.025, beta = 0.1, xi2 = 0.7, xi3 = 0.7,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 case = 2, fixed = TRUE)
          res <- utility3(d2 = 50, HRgo = 0.8,  w = 0.3, 
                                 hr1 =  0.69, hr2 = 0.81, 
                                 id1 = 210, id2 = 420, 
                                 alpha = 0.025, beta = 0.1, xi2 = 0.7, xi3 = 0.7,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 case = 2, fixed = TRUE)
         res <- utility4(d2 = 50, HRgo = 0.8,  w = 0.3, 
                                 hr1 =  0.69, hr2 = 0.81, 
                                 id1 = 210, id2 = 420, 
                                 alpha = 0.025, beta = 0.1, xi2 = 0.7, xi3 = 0.7,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 case = 3, fixed = TRUE)
}
\keyword{internal}
