% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beat.R
\name{beat}
\alias{beat}
\title{Play a drum sound}
\usage{
beat(drum = "snare", kit = "acoustic", expr = NULL)
}
\arguments{
\item{drum}{character string or number specifying which drum is to be played by 
specifying one of the built in sounds. The default is "snare". Every kit includes at 
least four pieces:
\enumerate{ \item \code{"kick"} \item \code{"snare"} \item \code{"hihat"}
\item \code{"crash"}}
If \code{drum} does not match any
of the options in this list, a random sound will be played.}

\item{kit}{character string specifying which kit is to be used. The default is "acoustic."
Possible kits are:
\enumerate{ \item \code{"acoustic"} \item \code{"hiphop"} \item \code{"electro"}
\item \code{"beatbox"} \item \code{"world"} \item \code{"r2d2"}}
 If \code{kit} does not match any
 of the options in this list, a random sound will be played.}

\item{expr}{An optional expression to be executed before the sound.}
}
\description{
\code{beat} plays a drum beat.
}
\examples{
# Play a "snare" sound from the "acoustic" kit
beat()

# Play a bass sound from the hiphop kit.
beat(drum="kick", kit="hiphop")

}
