% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.length.R
\name{ds.length}
\alias{ds.length}
\title{Gets the length of an object in the server-side}
\usage{
ds.length(x = NULL, type = "both", checks = "FALSE", datasources = NULL)
}
\arguments{
\item{x}{a character string specifying the name of a vector or list.}

\item{type}{a character that represents the type of analysis to carry out.
If \code{type} is set to \code{'combine'}, \code{'combined'}, \code{'combines'} or \code{'c'},
 a global length is returned
if \code{type} is set to \code{'split'}, \code{'splits'} or \code{'s'}, 
the length is returned separately for each study.
if \code{type} is set to \code{'both'} or \code{'b'}, 
both sets of outputs are produced. 
Default \code{'both'}.}

\item{checks}{logical. If TRUE the model components are checked. 
Default FALSE to save time. It is suggested that checks
should only be undertaken once the function call has failed.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.length} returns to the client-side the pooled length of a vector or a list, 
or the length of a vector or a list for each study separately.
}
\description{
This function gets the length of a vector
or list that is stored on the server-side. 
This function is similar to the R function \code{length}.
}
\details{
Server function called: \code{lengthDS}
}
\examples{
\dontrun{

  ## Version 6, for version 5 see the Wiki
  
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
  # Example 1: Get the total number of observations of the vector of
  # variable 'LAB_TSC' across all the studies
  ds.length(x = 'D$LAB_TSC', 
            type = 'combine',
            datasources = connections)

  # Example 2: Get the number of observations of the vector of variable
  # 'LAB_TSC' for each study separately
  ds.length(x = 'D$LAB_TSC',
            type = 'split',
            datasources = connections)

  # Example 3: Get the number of observations on each study and the total
  # number of observations across all the studies for the variable 'LAB_TSC'
  ds.length(x = 'D$LAB_TSC',
            type = 'both',
            datasources = connections)
  
  # clear the Datashield R sessions and logout
  datashield.logout(connections)
}

}
\author{
DataSHIELD Development Team
}
