% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue-permutations.R
\name{pt_refit}
\alias{pt_refit}
\title{Permutation Test By Refitting}
\usage{
pt_refit(x_train, x_test, scorer, n_pt = 2000)
}
\arguments{
\item{x_train}{Training (reference/validation) sample.}

\item{x_test}{Test sample.}

\item{scorer}{Function which returns a named list with outlier scores from
the training and test sample. The first argument to \code{scorer} must be
\code{x_train}; the second, \code{x_test}. The returned named list contains
two elements: \emph{train} and \emph{test}, each of which is a vector of
corresponding (outlier) scores. See notes below for more information.}

\item{n_pt}{The number of permutations.}
}
\value{
A named list of class \code{outlier.test} containing:
\itemize{
   \item \code{statistic}: observed WAUC statistic
   \item \code{seq_mct}: sequential Monte Carlo test, when applicable
   \item \code{p_value}: p-value
   \item \code{outlier_scores}: outlier scores from training and test set
}
}
\description{
Test for no adverse shift with outlier scores. Like goodness-of-fit testing,
this two-sample comparison takes the training set, \code{x_train} as the
as the reference. The method checks whether the test set, \code{x_test}, is
worse off relative to this reference set. The function \code{scorer} assigns
an outlier score to each instance/observation in both training and test set.
}
\details{
The null distribution of the test statistic is based on \code{n_pt}
permutations. For speed, this is implemented as a sequential Monte Carlo test
with the \pkg{simctest} package. See Gandy (2009) for details. The prefix
\emph{pt} refers to permutation test. This approach does not use the
asymptotic null distribution for the test statistic. This is the recommended
approach for small samples. The test statistic is the weighted AUC (WAUC).
}
\section{Notes}{

The scoring function, \code{scorer}, predicts out-of-sample scores by
refitting the underlying algorithm from \code{scorer} at every permutation
The suffix \emph{refit} emphasizes this point. This is in contrast to the
out-of-bag variant, \code{pt_oob}, which only fits once. This method can be
be computationally expensive.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
data(iris)
setosa <- iris[1:50, 1:4] # Training sample: Species == 'setosa'
versicolor <- iris[51:100, 1:4] # Test sample: Species == 'versicolor'
scorer <- function(tr, te) list(train=runif(nrow(tr)), test=runif(nrow(te)))
pt_test <- pt_refit(setosa, versicolor, scorer = scorer)
pt_test
}

}
\references{
Kamulete, V. M. (2022).
\emph{Test for non-negligible adverse shifts}.
In The 38th Conference on Uncertainty in Artificial Intelligence. PMLR.

Gandy, A. (2009).
\emph{Sequential implementation of Monte Carlo tests with uniformly bounded resampling risk}.
Journal of the American Statistical Association, 104(488), 1504-1511.
}
\seealso{
[pt_oob()] for (faster) p-value approximation via out-of-bag predictions.
[at_oob()] for p-value approximation from asymptotic null distribution.

Other permutation-test: 
\code{\link{pt_from_os}()},
\code{\link{pt_oob}()}
}
\concept{permutation-test}
