% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_ht.R
\name{row_prop_anno}
\alias{row_prop_anno}
\title{Annotate Row Proximity on Heatmap}
\usage{
row_prop_anno(
  sorted_dat,
  layout,
  split_vec,
  palette = "Spectral",
  n_colors = 11,
  border = TRUE,
  gap_mm = unit(1, "mm"),
  show_row_prox = TRUE
)
}
\arguments{
\item{sorted_dat}{List from \code{sorted_mat()}}

\item{layout}{List with layout dimensions}

\item{split_vec}{Factor dividing columns of the proximity matrix into groups.}

\item{palette}{RColorBrewer palette name for color scale (default "OrRd").}

\item{n_colors}{Number of discrete colors to generate (default 9).}

\item{border}{Logical; draw cell borders if TRUE (default TRUE).}

\item{gap_mm}{Unit object for gap between annotation blocks (default \code{unit(1, "mm")} ).}

\item{show_row_prox}{Logical, whether to show row proximity.}
}
\value{
A \code{rowAnnotation} object for use in a ComplexHeatmap.
}
\description{
Creates a ComplexHeatmap row annotation showing supervised proximity
for each data sample, grouped by a split vector.
}
\keyword{internal}
