% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mean_i}
\alias{mean_i}
\title{Mean of Integer Values}
\usage{
mean_i(x)
}
\arguments{
\item{x}{Integer vector or matrix.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function runs faster than \code{\link[base]{mean}} for 
large integer vectors/matrices.
}
\examples{
# For very large integer objects, sum_i is faster than sum
x <- rpois(100000, lambda = 5)
mean(x) == mean_i(x)
benchmark(mean(x), mean_i(x), replications = 1000)

# For smaller integer objects, sum_i is slower than sum 
x <- rpois(1000, lambda = 5)
mean(x) == mean_i(x)
benchmark(mean(x), mean_i(x), replications = 1000)

}
