% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_cut.R
\name{reverse_cut}
\alias{reverse_cut}
\title{Reverse Cut}
\usage{
reverse_cut(x, breaks, include.lowest = FALSE, right = TRUE, ...)
}
\arguments{
\item{x, breaks, include.lowest, right}{See \code{\link{cut}}.
specifying number of intervals is not currently supported).}

\item{...}{Arguments to pass to \code{\link{cut}}.}
}
\value{
Factor variable.
}
\description{
Convenience function to get reversed factor levels from \code{\link{cut}}. 
Currently requires specifying \code{breaks} as vector of cutpoints rather 
than number of desired intervals.
}
\examples{
# In mtcars dataset, create 3 mpg groups
table(cut(mtcars$mpg, breaks = c(-Inf, 15, 20, Inf)))

# Repeat with reverse_cut to get factor levels ordered from high to low
table(reverse_cut(mtcars$mpg, breaks = c(Inf, 20, 15, -Inf)))

# You can specify breaks from low to high, but then include.lowest and right 
# arguments get confusing
table(reverse_cut(mtcars$mpg, breaks = c(-Inf, 15, 20, Inf), right = TRUE))

}
