% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logodds_graph.R
\name{logodds_graph}
\alias{logodds_graph}
\title{Graph Log-Odds of Binary Variable Across A Grouping Variable}
\usage{
logodds_graph(y, group, error.bars = "none", alpha = 0.05,
  p.legend = "chi", plot.list = NULL, lines.list = NULL,
  axis.list = NULL, legend.list = NULL, ...)
}
\arguments{
\item{y}{Vector of values for binary response variable. Must take on 2 
values, but can be any type (e.g. numeric, character, factor, logical). 
Function plots log-odds of second value returned by \code{table(y)}.}

\item{group}{Vector of values indicating what group each \code{y} observation 
belongs to. Function plots group levels across x-axis in same order as 
\code{table(group)}.}

\item{error.bars}{Character string indicating what the error bars should 
represent. Possible values are \code{"exact.ci"} for exact 95\% confidence 
interval based on binomial distribution, \code{"z.ci"} for approximate 95\% 
confidence interval based on Z distribution, and \code{"none"} for no error 
bars.}

\item{alpha}{Numeric value indicating what alpha should be set to for 
confidence intervals. Only used if \code{error.bars} is \code{"exact.ci"} or 
\code{"z.ci"}.}

\item{p.legend}{Character string controlling what p-value is printed in a 
legend. Possible values are \code{"chi"} for Chi-square test of association, 
\code{"fisher"} for Fisher's exact test, and \code{"none"} for no legend at 
all.}

\item{plot.list}{Optional list of inputs to pass to 
\code{\link[graphics]{plot}} function.}

\item{lines.list}{Optional list of inputs to pass to 
\code{\link[graphics]{lines}} function.}

\item{axis.list}{Optional list of inputs to pass to 
\code{\link[graphics]{axis}} function.}

\item{legend.list}{Optional list of inputs to pass to 
\code{\link[graphics]{legend}} function.}

\item{...}{Additional arguments to pass to \code{\link[stats]{chisq.test}} or
\code{\link[stats]{fisher.test}} functions.}
}
\value{
Plot showing log-odds of \code{y} across levels of \code{group}.
}
\description{
Creates plot showing sample log-odds of binary Y variable across levels of a
grouping variable, with customizable error bars. Observations with missing 
values for \code{y} and/or \code{group} are dropped.
}
