% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_explan_data}
\alias{sample_explan_data}
\title{Sample species occurrence records with associated dynamic explanatory variables}
\format{
A data frame with 330 rows and 17 variables:
\describe{
\item{x}{species occurrence record longitude.}
\item{y}{species occurrence record latitude.}
\item{year}{species occurrence record year.}
\item{month}{species occurrence record month.}
\item{day}{species occurrence record day.}
\item{decimalLatitude}{species occurrence record latitude.}
\item{decimalLongitude}{species occurrence record longitude.}
\item{occurrenceStatus}{species presence or absence character.}
\item{source}{source of occurrence or pseudo-absence data point.}
\item{species}{name of species occurrence records belong to name}
\item{SAMP_EFFORT}{total number of avian e-Bird sampling events within spatiotemporal buffer of
occurrence record location and dates.}
\item{REL_SAMP_EFFORT}{proportion of total number of avian e-Bird sampling events within
spatiotemporal buffer of occurrence record location and dates relative to other records}
\item{unique.ID.DYN}{unique id value assigned when extracting dynamic explanatory variable
data}
\item{eight_sum_prec}{sum Climate Hazards Group InfraRed Precipitation With Station Data (Funk
et al., 2016) total daily precipitation at record co-ordinate across 52-weeks prior to record
date (mm).}
\item{grass_crop_percentage}{total number of MODIS Land Cover Type Yearly 500m (Friedl &
Sulla-Menashe, 2019) "cereal cropland" and "grassland" cells in surrounding area of record
co-ordinate in record year.}
\item{year_sum_prec}{sum Climate Hazards Group InfraRed Precipitation With Station Data (CHIRPS
Daily) total daily precipitation at record co-ordinate across 52-weeks prior to record date
(mm).}
\item{presence.absence}{binary species presence or absence at record location and date.}
}
}
\usage{
sample_explan_data
}
\description{
A dataset containing a sample of the bird species, the red-billed quelea (Quelea
quelea), distribution records from between 2002-2019 (GBIF 2021, GBIF 2022); generated
pseudo-absence records, and associated extracted dynamic explanatory variables. The variables
are as follows:
}
\references{
Friedl, M., Sulla-Menashe, D. (2019). MCD12Q1 MODIS/Terra+Aqua Land Cover Type Yearly L3 Global
500m SIN Grid V006. NASA EOSDIS Land Processes DAAC.

Funk, Chris, Pete Peterson, Martin Landsfeld, Diego Pedreros, James Verdin, Shraddhanand Shukla,
Gregory Husak, James Rowland, Laura Harrison, Andrew Hoell & Joel Michaelsen. "The climate
hazards infrared precipitation with stations-a new environmental record for monitoring extremes".
Scientific Data 2, 150066. doi:10.1038/sdata.2015.66 2015.

GBIF.org (12 July 2021) GBIF Occurrence Download \doi{10.15468/dl.ppcu6q}

GBIF.org (25 July 2022) GBIF Occurrence Download \doi{10.15468/dl.k2kftv}
}
\keyword{datasets}
