% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnc_calc_time_diff.R
\name{calc_time_diff}
\alias{calc_time_diff}
\title{Calculate time differences for suitable vectors.}
\usage{
calc_time_diff(
  x = NULL,
  d_start = NULL,
  type = c("mon", "day", "year"),
  origin = "1900-01-01",
  exact = FALSE
)
}
\arguments{
\item{x}{A vector of dates or character in format 'yyyy-mm-dd'.}

\item{d_start}{A specific start date (if unspecified the minimum of x will be used to ensure positive values).}

\item{type}{You may specify 'year' or 'day' instead of month here.}

\item{origin}{The origin used.}

\item{exact}{Function will return exact values instead of full month and year if this is set to TRUE.}
}
\value{
A numeric vector of length \code{x} containing calculated time differences
in the unit specified by \code{type}. Not a difftime object.
}
\description{
Calculation of a time difference between time points in a vector \code{x} and
a specific start date \code{d_start} in month (days or years).
}
\examples{
x <- c("2022-02-01", "2022-02-03", "2022-03-01", "2024-02-01")
calc_time_diff(x = x)
calc_time_diff(x = x, exact = TRUE)
calc_time_diff(x = x, type = "day")
calc_time_diff(x = x, type = "year")
calc_time_diff(x = x, type = "year", d_start = "2021-12-31")
calc_time_diff(x = 1:3, type = "day", origin = Sys.Date())
}
