% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation.r
\name{mutation}
\alias{mutation}
\title{Generate mutated DNA sequences}
\usage{
mutation(sequence = NULL, format = "bin", n.mutations = NA, prob.mutation = NA)
}
\arguments{
\item{sequence}{A list of DNA sequences, either as "DNAbin" objects or character vectors.}

\item{format}{Character. Format of the input sequences. "bin" for DNAbin, "char" for character vectors.}

\item{n.mutations}{Integer. Number of mutations to introduce per sequence. Exclusive with prob.mutation.}

\item{prob.mutation}{Numeric. Probability of mutation per position. Exclusive with n.mutations.}
}
\value{
A list of mutated sequences of the same class as the input.
}
\description{
This function takes DNA sequences and generates mutated variants.
Useful for testing classification algorithms on sequences with either PCR-induced or naturally occurring mutations.
}
\examples{
data("test_seqs")
mutation(test_seqs, n.mutations = 2)
mutation(test_seqs, prob.mutation = 0.1)
seqs <- fasta_reader(system.file("extdata", "test.fasta", package="eDNAfuns"))
mutation(seqs$seq, format = "char", n.mutations = 1)

}
