% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fasta.r
\name{fasta_reader}
\alias{fasta_reader}
\alias{fastq_reader}
\title{Read FASTA or FASTQ files into a tibble}
\usage{
fasta_reader(path_to_fasta)

fastq_reader(path_to_fastq, keepQ = FALSE)
}
\arguments{
\item{path_to_fasta}{Character. Path to a FASTA file.}

\item{path_to_fastq}{Character. Path to a FASTQ file.}

\item{keepQ}{Logical. If `TRUE`, keep a third column with quality scores when
reading FASTQ files. Default is `FALSE`.}
}
\value{
- `fasta_reader()`: A tibble with columns:
  - `header`: sequence identifiers (without the `>`).
  - `seq`: nucleotide sequences.

- `fastq_reader()`: A tibble with columns:
  - `header`: sequence identifiers (without the `@`).
  - `seq`: nucleotide sequences.
  - `Qscores` (optional): quality scores, if `keepQ = TRUE`.
}
\description{
Functions to read sequence files into a tidy data frame with one row per sequence.
}
\examples{

fasta_df <- fasta_reader(system.file("extdata", "test.fasta", package="eDNAfuns"))
fastq_df <- fastq_reader(system.file("extdata", "test.fastq", package="eDNAfuns"), keepQ = TRUE)


}
