% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{AIC.fcm}
\alias{AIC.fcm}
\title{Akaike Information Criterion (AIC) for fcm objects}
\usage{
\method{AIC}{fcm}(object, ..., k = 2)
}
\arguments{
\item{object}{An object of class \code{fcm}, created by \code{\link[=fcm]{fcm()}}.}

\item{...}{Currently unused.}

\item{k}{Penalty per parameter (default is \code{k = 2}).}
}
\value{
A numeric scalar giving the AIC value for the fitted model.
}
\description{
Compute the AIC value for a fitted \code{fcm} model using the formula:
\deqn{\mathrm{AIC} = -2 \cdot \log L + k \cdot p}
where \eqn{L} is the likelihood, \eqn{p} is the number of parameters, and \eqn{k} is a penalty parameter.
}
\seealso{
\code{\link[=logLik.fcm]{logLik.fcm()}}, \code{\link[=BIC.fcm]{BIC.fcm()}}, \code{\link[=AICc.fcm]{AICc.fcm()}}
}
