% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighborhood.R
\name{neighborhood_HT}
\alias{neighborhood_HT}
\title{Homogeneous neighborhood selection}
\usage{
neighborhood_HT(
  data,
  coord,
  s0,
  miles = FALSE,
  min.neigh = 5,
  max.neigh = 20,
  pr = 0.9,
  alpha = 0.05,
  dmax = 150,
  which.test = c(1, 2)
)
}
\arguments{
\item{data}{A matrix or data.frame. Each column corresponds to a station, with rows containing observations (on the original scale).}

\item{coord}{A two-column matrix or data frame of station coordinates (longitude and latitude), one row per station.}

\item{s0}{Numeric vector of length 2: the longitude and latitude of the target grid point.}

\item{miles}{Logical; whether to compute distance in miles (default: FALSE).}

\item{min.neigh}{Minimum number of neighbors to accept (default: 5).}

\item{max.neigh}{Maximum number of neighbors to test (default: 20).}

\item{pr}{Probability threshold for quantile filtering (e.g. 0.9).}

\item{alpha}{Significance level for homogeneity tests.}

\item{dmax}{Maximum distance (in km) to consider.}

\item{which.test}{Integer vector specifying which test(s) to run:
\itemize{
\item 1 = HW test (Hosking–Wallis)
\item 2 = AD test (Anderson–Darling)
\item c(1, 2) = both tests
}}
}
\value{
A vector of station indices considered homogeneous with the grid point.
}
\description{
Identifies homogeneous neighbors around a given grid point using a combination
of the Hosking-Wallis (1993) and Anderson-Darling (1987) tests for marginal homogeneity.
}
\examples{
\donttest{
neighborhood_HT(counterfactual, coord = LonLat, s0 = c(30, 39), which.test = c(1, 2))
}

}
\references{
Castro-Camilo, D. and Huser, R. (2020). \emph{JASA} 115, 1037–1054.
Hosking, J. and Wallis, J. (1993). \emph{Water Resour. Res.} 29, 271–281.
Scholz, F.W. and Stephens, M.A. (1987). \emph{JASA} 82, 918–924.
}
\seealso{
\code{\link[=fdata]{fdata()}}
}
