% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level.R
\name{review_quality_ctrl}
\alias{review_quality_ctrl}
\title{Review Quality Control}
\usage{
review_quality_ctrl(before_tbl, after_tbl, id_var)
}
\arguments{
\item{before_tbl}{Data frame from before modifications were made.}

\item{after_tbl}{Data frame from after modifications were made.}

\item{id_var}{An unquoted expression which corresponds to a variable in both
\code{before_tbl} and \code{after_tbl} which identifies each row. Required.}
}
\value{
List containing data for review of quality control
}
\description{
Provides information on modifications made to a dataset at both variable
(column) and value (sample) levels, designed for review of quality control
measures.
}
\details{
Modifications are identified by comparing the original and modified dataset.

QC review functions are applied in the following order:
\enumerate{
\item Variable-level modifications (\code{\link{report_var_mods}})
\item Value-level modifications (\code{\link{mod_track}})
\item Value-level modifications (plot) (\code{\link{mod_track}})
}
A list containing each of these functions' outputs is returned.
}
\examples{
data(example_data)
require(tibble)

tibble::tribble(~"var", ~"datatype",
"patient_id", "id",
"tumoursize", "numeric",
"t_stage", "ordinal_tstage",
"n_stage", "ordinal_nstage",
"diabetes", "factor",
"diabetes_type", "ordinal",
"hypertension", "factor",
"rural_urban", "factor",
"marital_status", "factor",
"SNP_a", "genotype",
"SNP_b", "genotype",
"free_text", "freetext") -> data_types

   
# create QC'ed dataset
post_QC_example_data <- apply_quality_ctrl(example_data,
                                           patient_id,
                                           data_types,
                                           bin_cats =c("No" = "Yes",
                                                       "rural" = "urban"),
                                           min_freq = 0.6)

# review QC
QC_review <- review_quality_ctrl(before_tbl = example_data,
                    after_tbl = post_QC_example_data,
                    id_var = patient_id)

# view variable level changes
QC_review$variable_level_changes

# view value level changes
QC_review$value_level_changes

# view value level changes as a plot
QC_review$value_level_changes_plt

}
\seealso{
Other high level functionality: 
\code{\link{apply_quality_ctrl}()},
\code{\link{assess_quality}()},
\code{\link{semantic_enrichment}()}
}
\concept{high level functionality}
