% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-nasa-stacs.R
\name{get_nasa_stac_url}
\alias{get_nasa_stac_url}
\title{Get NASA STAC URL for a Provider}
\usage{
get_nasa_stac_url(provider, cloud_only = TRUE)
}
\arguments{
\item{provider}{Character; the name of the NASA STAC provider}

\item{cloud_only}{Logical; if TRUE (default), returns only cloud-hosted STAC
catalogs}
}
\value{
A character string containing the STAC catalog URL for the specified
provider
}
\description{
Retrieves the STAC catalog URL for a specific NASA provider
}
\examples{
\dontrun{
get_nasa_stac_url("LPDAAC", cloud_only = FALSE)
get_nasa_stac_url("LPCLOUD")
}

}
\seealso{
\code{\link[=list_nasa_stacs]{list_nasa_stacs()}}
}
